-- contains seed data for report_template and report_template_configuration 
/**
 * Logic for logo : by default logo will be taken by academy location wise. If you want to set custom logo then set its values
 * in "defaultHeaderLogo"
 * if defaultHeaderLogo is not null : it will take custom logo
 * if defaultHeaderLogo is null : it will take logo from academy location wise.
 */

set foreign_key_checks=0;
truncate table report_type;
truncate table report_template;
truncate table report_template_configuration;
truncate table report_type;
set foreign_key_checks=0;


-- Report types
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('1', 'Receipt');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('2', 'Mark Sheet');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('3', 'Bill');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('4', 'Receipt with Settlement');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('5', 'Time Table');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('6', 'Statement Of Account Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('7', 'ID Card');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('8', 'Hall Ticket');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('9', 'Receipt With Head Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('10', 'Basic Reports');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('11', 'Fee Plan');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('12', 'Ageing Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('13', 'Employee ID Card');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('14', 'Tabulation Register');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('15', 'Examination Form');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('16', 'Exam Roll List');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('17', 'Examination Foils Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('18', 'Examination Absentee Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('19', 'Examination Attendance Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('20', 'Grade Roster Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('21', 'Course Roster Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('22', 'Cross List Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('23', 'User Wise Collection Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('24', 'Summary Report');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('25', 'Fee Reports');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('26', 'Student Assessment Reports');
INSERT INTO `report_type` (`id`, `typeName`) VALUES ('27', 'Student Photo Report');

INSERT INTO `report_template` VALUES 
(1,1,'MANAGE_RECEIPT_CODE','Simple Receipt - Triplicate','ReceiptTriplicate.png','CommonReport.jasper',NULL,'All',0,'FooterBlank.jasper','FooterBlank.jasper',0,0,'ManageReceipt_Triplet.jasper','AcademiaLogo.png'),
(2,3,'MANAGE_BILLS_CODE','Bill','Bill.png','CommonReport.jasper',NULL,'All',1,'Header.jasper','Footer.jasper',0,0,'ManageBill.jasper','AcademiaLogo.jpg'),
(3,4,'MANAGE_RECEIPT_SETTLEMENT_CODE','Detailed Receipt - One Page','SettlementOnePage.png','CommonReport.jasper',NULL,'All',0,'Header.jasper','Footer.jasper',0,0,'ManageReceiptSettlement.jasper','AcademiaLogo.jpg'),
(4,4,'MANAGE_RECEIPT_SETTLEMENT_CODE','Detailed Receipt - Urdu','Detailed_Receipt_Urdu.png','CommonReport.jasper',NULL,'All',0,'FooterBlank.jasper','FooterBlank.jasper',0,0,'installmentWiseReceipt.jasper','AcademiaLogo.jpg'),
(5,2,'MARKSHEET_LEVEL_ZERO_COURSE','Course Level - Grade Type - Format 1','MARKSHEET_LEVEL_ZERO_COURSE.png','CommonReport.jasper','EVALUATION_PLAN','All',1,'Header.jasper','FooterBlank.jasper',0,0,'marksheetTemplate_Course_1.jasper','AcademiaLogo.jpg'),
(6,2,'MARKSHEET_LEVEL_TWO_SUB_TYPE','Marks Type - SubType Level - Format 1','MARKSHEET_LEVEL_TWO_SUB_TYPE.png','CommonReport_LandScape.jasper','EVALUATION_SUB_TYPE','All',1,'Header_LandScape_Marksheet.jasper','Footer_LandScape_Marksheet.jasper',0,0,'marksheetTemplate_Subtype_1.jasper','AcademiaLogo.jpg'),
(7,2,'MARKSHEET_UOA_TWO_SUB_TYPE','UoA - All','MARKSHEET_UOA_TWO_SUB_TYPE.png','CommonReport.jasper','EVALUATION_SUB_TYPE','All',1,'Header_UoA.jasper','Footer_UoA.jasper',1,1,'marksheet_UoA_Subtype_1.jasper','AcademiaLogo.png'),
(8,4,'MANAGE_RECEIPT_SETTLEMENT_CODE','Detailed Receipt - Triplicate(College)','SettlementTriplicateCollege.png','CommonReport_LandScape.jasper',NULL,'All',1,'HeaderBlank_LandScape.jasper','FooterBlank.jasper',0,0,'feeReceipt_JLU.jasper','AcademiaLogo.png'),
(9,2,'PHARMA_MARKSHEET','Course Level - Grade Type - Format 2','PHARMA_MARKSHEET.png','CommonReport.jasper','EVALUATION_PLAN','All',1,'Header_People_1.jasper','FooterBlank.jasper',0,0,'peoplesPharmaCourseLevel.jasper','peoples_header.png'),
(10,1,'MANAGE_RECEIPT_CODE','Simple Receipt - Duplicate','ReceiptSchool.png','CommonReport.jasper',NULL,'All',1,'FooterBlank.jasper','FooterBlank.jasper',0,0,'ManageReceipt_double.jasper','AcademiaLogo.png'),
(11,2,'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_1', 'Jaipuria - Class UKG to II - FA Type', 'Method_Level_Mark_Sheet_Format_1.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_1.jasper', 'AcademiaLogo.png'),
(12,2,'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_3', 'Jaipuria - Class V to VIII - FA SubType', 'Method_Level_Mark_Sheet_Format_2.png', 'CommonReport.jasper','EVALUATION_SUB_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_3.jasper', 'AcademiaLogo.png'),
(13,5, 'MASTER_TIME_TABLE_CODE', 'Master Time Table Format', 'MASTER_TIME_TABLE_CODE.png', 'CommonReport_LandScape.jasper',NULL, 'All', 1, 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', 0, 0, 'masterTimeTable.jasper', 'AcademiaLogo.jpg'),
(14,2, 'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_1', 'Jaipuria - Class V to VIII - Term Based','MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_1.png' ,'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_4.jasper', 'AcademiaLogo.png'),
(15,6,'STATEMENT_OF_ACCOUNT_REPORT','Statement Of Account Report','STATEMENT_OF_ACCOUNT_REPORT.png','CommonReport_LandScape.jasper',NULL,'All',1,'HeaderBlank_LandScape.jasper','FooterBlank.jasper',1,1,'ledgerReport.jasper','AcademiaLogo.png'),
(16,4,'MANAGE_RECEIPT_SETTLEMENT_CODE','Detailed Receipt - Triplicate(School)','SettlementTriplicateSchool.png','CommonReport_LandScape.jasper',NULL,'All',0,'HeaderBlank_LandScape.jasper','FooterBlank.jasper',0,0,'schoolFeeReceipt.jasper','AcademiaLogo.png'),
(17,7,'ID_CARD_FRONT', 'Student ID Card Front', 'ID_CARD_FRONT.png', 'CommonReport_IdCard.jasper',NULL, 'All', 1, 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', 1, 1, 'printStudentIdCardFrontSide.jasper', 'AcademiaLogo.png'),
(18,7,'ID_CARD_BACK', 'Student ID Card Back', 'ID_CARD_BACK.png', 'CommonReport_IdCard.jasper',NULL, 'All', 1, 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', 1, 1, 'printStudentIdCardBackSide.jasper', 'AcademiaLogo.png'),
(19,2,'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG', 'TSG - Type level marksheet', 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG.png', 'CommonReport.jasper','EVALUATION_TYPE','All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG.jasper', 'AcademiaLogo.png'),
(20,2, 'jlu_CourseLevel', 'jlu - Course level marksheet', 'jlu_CourseLevel.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', 1, 'FooterBlank.jasper', 'Footer_JLU.jasper', 1, 1, 'jlu_CourseLevel.jasper', 'AcademiaLogo.png'),
(21,2, 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED', 'TSG - Type level Health Based','MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED.png', 'CommonReport.jasper', 'EVALUATION_TYPE','All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED.jasper', 'AcademiaLogo.png'),
(22,2, 'MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG', 'TSG - Plan level Skill based','MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG.jasper', 'AcademiaLogo.png'),
(23,2, 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED', 'TSG - Plan level Health based','MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED.jasper', 'AcademiaLogo.png'),
(24,2, 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG_GRAY', 'TSG - Type level marksheet - Gray Shade', 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG_GRAY.png','CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG_GRAY.jasper', 'AcademiaLogo.png'),
(25,2, 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_GRAY', 'TSG - Type level Health Based - Gray Shade', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_GRAY.png','CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_GRAY.jasper', 'AcademiaLogo.png'),
(26,2, 'MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG_GRAY', 'TSG - Plan level Skill based - Gray Shade', 'MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG_GRAY.png','CommonReport.jasper','EVALUATION_PLAN', 'All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG_GRAY.jasper', 'AcademiaLogo.png'),
(27,2, 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_GRAY', 'TSG - Plan level Health based - Gray Shade', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_GRAY.png','CommonReport.jasper','EVALUATION_PLAN', 'All', 1, 'Header_TSG.jasper', 'Footer_TSG.jasper', 1, 1, 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_GRAY.jasper', 'AcademiaLogo.png'),
(28,8, 'JLU_COURSE_LEVEL_HALL_TICKET', 'JLU - Course level hall ticket', 'JLU_COURSE_LEVEL_HALL_TICKET.png','CommonReport.jasper',NULL, 'All', 1, 'Header_CenterSideLogo.jasper', 'FooterBlank.jasper', 1, 1, 'JLU_COURSE_LEVEL_HALL_TICKET.jasper', 'AcademiaLogo.png'),
(29,9, 'RECEIPT_WITH_HEAD_WISE_REPORT', 'Receipt With Head Report', 'RECEIPT_WITH_HEAD_WISE_REPORT.png', 'CommonReport_Excel.jasper',NULL, 'All', 1, 'Header_Excel_Blank.jasper', 'Footer_Excel_Blank.jasper', 1, 1, 'receiptWithHeadReport.jasper', 'AcademiaLogo.png'),
(30,2, 'HALF_MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG', 'TSG(Half) - Single term Skill/Sports marksheet', 'HALF_MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG.png', 'CommonReport_HALF.jasper','EVALUATION_TYPE', 'All', 1, 'Header_TSG_HALF.jasper', 'Footer_TSG.jasper', 1, 1, 'TSG_HALF_TYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(31,2, 'HALF_MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG_G', 'TSG(Half) - Single term Skill/Sports marksheet-Gray shade', 'HALF_MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_TSG_G.png', 'CommonReport_HALF.jasper','EVALUATION_TYPE', 'All', 1, 'Header_TSG_HALF.jasper', 'Footer_TSG.jasper', 1, 1, 'TSG_HALF_TYPE_LEVEL_GRAY_MARKSHEET.jasper', 'AcademiaLogo.png'),
(32,2, 'HALF_MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG', 'TSG(Half) - Consolidated Skill/Sports marksheet', 'HALF_MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG.png', 'CommonReport_HALF.jasper','EVALUATION_PLAN', 'All', 1, 'Header_TSG_HALF.jasper', 'Footer_TSG.jasper', 1, 1, 'TSG_HALF_PLAN_TO_METHOD_MARKSHEET.jasper', 'AcademiaLogo.png'),
(33,2, 'HALF_MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG_G', 'TSG(Half) - Consolidated Skill/Sports marksheet-Gray Shade', 'HALF_MARKSHEET_PLAN_TO_METHOD_TEMPLATE_TSG_G.png', 'CommonReport_HALF.jasper','EVALUATION_PLAN', 'All', 1, 'Header_TSG_HALF.jasper', 'Footer_TSG.jasper', 1, 1, 'TSG_HALF_PLAN_TO_METHOD_GRAY_MARKSHEET.jasper', 'AcademiaLogo.png'),
(34,10,'CourseWiseMarksheetReport','Course Wise Marksheet Report','CourseWiseMarksheetReport.png','CommonReport_Marksheet_Excel.jasper',NULL,'All',1,'Header_Excel.jasper','Header_Excel.jasper',0,0,'CourseWiseMarksheetReport.jasper','AcademiaLogo.png'),
(35,10,'CreditBasedExamReport','Credit Based Examination Report','CreditBasedExamReport.png','CommonReport_Excel.jasper',NULL,'All',1,'Header_Excel.jasper','Footer_Excel.jasper',0,0,'CreditBasedExamReport.jasper','AcademiaLogo.png'),
(36,10,'ApplicantDetailReport','Applicant Detail Report','ApplicantDetailReport.png','CommonReport_Excel.jasper',NULL,'All',1,'Header_Excel.jasper','Footer_Excel.jasper',0,0,'ApplicantDetailReport.jasper','AcademiaLogo.png'),
(37,10,'ApplicationSummaryReport','Application Summary Report','ApplicationSummaryReport.png','CommonReport_PageBoder_DRS.jasper',NULL,'All',1,'Header_Application_summary.jasper','Footer_UoA.jasper',1,1,'ApplicationSummaryReport.jasper','AcademiaLogo.png'),
(38,10,'EXAM_TIME_TABLE_COMMON','Common Exam Time Table','ExamTimeTableCommon.png','CommonReport.jasper',NULL,'All',1,'Header_CenterSideLogo.jasper','FooterBlank.jasper',1,1,'ExamTimeTableCommon.jasper','AcademiaLogo.png'),
(39,11,'FEE_PLAN_PRINT','Fee Plan Print','FEE_PLAN_PRINT.png','CommonReport_Legal.jasper',NULL,'All',1,'Header.jasper','Footer.jasper',1,1,'feePlanPrint.jasper','AcademiaLogo.png'),
(40,12, 'BILL_AGEING_REPORT_STUDENT', 'Ageing Report', 'BILL_AGEING_REPORT_STUDENT.png', 'CommonReport_Excel.jasper',NULL, 'All', 1, 'Header_Excel.jasper', 'Footer_Excel.jasper', 1, 1, 'ageingReport.jasper', 'AcademiaLogo.png'),
(41,3,'MANAGE_BILLS_CODE','Bill Tabular Format','BillFormatOne.png','CommonReport.jasper',NULL,'All',0,'Header_BillAndFee.jasper','Footer_BillAndFee.jasper',0,0,'manageBill_Format1.jasper','AcademiaLogo.jpg'),
(42,4,'MANAGE_RECEIPT_SETTLEMENT_CODE','Receipt Settlement Format One','Detailed_Receipt_One Page.png','CommonReport.jasper',NULL,'All',0,'Header.jasper','Footer.jasper',0,0,'ManageReceiptSettlement_Format1.jasper','AcademiaLogo.jpg'),
(43,2,'COURSE_LEVEL_CREDIT_BASED_CONSOLIDATE_TRANSCRIPT','Course Level Transcript','CourseLevelTranscript.png','CommonReport_PageBoder_DRS.jasper','EVALUATION_PLAN','All',1,'Header.jasper','FooterBlank.jasper',1,1,'COURSE_LEVEL_CREDIT_BASED_CONSOLIDATE_TRANSCRIPT.jasper','AcademiaLogo.jpg'),
(44,2,'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_1_MARK', 'Type Level Marks Report', 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_1_MARK.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_1_MARK.jasper', 'AcademiaLogo.png'),
(45,2,'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_3_MARK', 'Sub Type Level Marks Report', 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_3_MARK.png', 'CommonReport.jasper','EVALUATION_SUB_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_TEMPLATE_3_MARK.jasper', 'AcademiaLogo.png'),
(46,2,'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_4_MARK', 'Term Based Consolidated Marks Report','MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_4_MARK.png', 'CommonReport.jasper', 'EVALUATION_TYPE','All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_4_MARK.jasper', 'AcademiaLogo.png'),
(47,2,'MARKSHEET_LEVEL_ONE_FULL_CONS_TEMPLATE_5', 'Term Based Full Consolidated Report','MARKSHEET_LEVEL_ONE_FULL_CONS_TEMPLATE_5.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_FULL_CONS_TEMPLATE_5.jasper', 'AcademiaLogo.png'),
(48,2,'MARKSHEET_LEVEL_ONE_FULL_CONS_TEMPLATE_5_MARK', 'Term Based Full Consolidated Marks Report','MARKSHEET_LEVEL_ONE_FULL_CONS_TEMPLATE_5_MARK.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_FULL_CONS_TEMPLATE_5_MARK.jasper', 'AcademiaLogo.png'),
(49,2,'MARKSHEET_LEVEL_ONE_FULL_CONS_HORIZONTAL', 'Term Based Full Consolidated Horizontal Report','MARKSHEET_LEVEL_ONE_FULL_CONS_HORIZONTAL.png', 'CommonReport_LandScape_JAIPURIA.jasper','EVALUATION_TYPE', 'All', 1, 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_FULL_CONS_HORIZONTAL.jasper', 'AcademiaLogo.png'),
(50,2,'MARKSHEET_LEVEL_ONE_FULL_CONS_HORIZONTAL_MARK', 'Term Based Full Consolidated Horizontal Marks Report','MARKSHEET_LEVEL_ONE_FULL_CONS_HORIZONTAL_MARK.png', 'CommonReport_LandScape_JAIPURIA.jasper','EVALUATION_TYPE', 'All', 1, 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_FULL_CONS_HORIZONTAL_MARK.jasper', 'AcademiaLogo.png'),
(51,2,'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_2', 'Type Level Sort Report','MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_2.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'FooterBlank.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_2.jasper', 'AcademiaLogo.png'),
(52,2,'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_2_MARK', 'Type Level Sort Marks Report','MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_2_MARK.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'FooterBlank.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_2_MARK.jasper', 'AcademiaLogo.png'),
(53,2,'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_3', 'Sub Type Level Sort Report','MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_3.png', 'CommonReport.jasper','EVALUATION_SUB_TYPE', 'All', 1, 'FooterBlank.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_3.jasper', 'AcademiaLogo.png'),
(54,2,'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_3_MARK', 'Sub Type Level Sort Marks Report','MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_3_MARK.png', 'CommonReport.jasper','EVALUATION_SUB_TYPE', 'All', 1, 'FooterBlank.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_THREE_METHOD_SORT_TEMPLATE_3_MARK.jasper', 'AcademiaLogo.png'),
(55,2,'MARKSHEET_LEVEL_ONE_TYPE_SORT_TEMPLATE_4', 'Term Based Sort Consolidated Report','MARKSHEET_LEVEL_ONE_TYPE_SORT_TEMPLATE_4.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'FooterBlank.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_TYPE_SORT_TEMPLATE_4.jasper', 'AcademiaLogo.png'),
(56,2,'MARKSHEET_LEVEL_ONE_TYPE_SORT_TEMPLATE_4_MARK', 'Term Based Sort Consolidated Marks Report','MARKSHEET_LEVEL_ONE_TYPE_SORT_TEMPLATE_4_MARK.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'FooterBlank.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_TYPE_SORT_TEMPLATE_4_MARK.jasper', 'AcademiaLogo.png'),
(57,2,'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_4', 'Term Based GDA Consolidated Report','MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_4.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_4.jasper', 'AcademiaLogo.png'),
(58,2,'MARKSHEET_TYPE_LEVEL_AVG_SORT_GDA', 'GDA Type level short Report','MARKSHEET_TYPE_LEVEL_AVG_SORT_GDA.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'FooterBlank.jasper', 'FooterBlank.jasper', 1, 1, 'MARKSHEET_TYPE_LEVEL_AVG_SORT_GDA.jasper', 'AcademiaLogo.png'),
(59,2,'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_IND_REMARK', 'Jaipuria - Class VI to VIII Term Based Co-Scholastic', 'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_IND_REMARK.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', 1, 'Header_RightSideLogo.jasper', 'Footer_Jaipuria.jasper', 1, 1, 'MARKSHEET_LEVEL_ONE_TYPE_TEMPLATE_IND_REMARK.jasper', 'AcademiaLogo.png'),
(60,4,'MANAGE_RECEIPT_SETTLEMENT_CODE','Receipt Settlement Tabular Format','BillFormatOne.png','CommonReport.jasper',NULL,'All',0,'Header_BillAndFee.jasper','Footer_BillAndFee.jasper',0,0,'ManageReceiptSettlement_Format2.jasper','AcademiaLogo.jpg'),
(61,1,'MANAGE_RECEIPT_CODE', 'Simple Receipt - Duplicate (Colleges)', 'ReceiptCollege.png', 'CommonReport.jasper',NULL, 'All', 0, 'FooterBlank.jasper', 'FooterBlank.jasper', 0, 0, 'ManageReceipt_double_college.jasper', 'AcademiaLogo.png'),
(62,1,'MANAGE_RECEIPT_CODE', 'Simple Receipt-Triplicate with STAMP', 'ReceiptStamp.png', 'CommonReport.jasper',NULL, 'All', 0, 'FooterBlank.jasper', 'FooterBlank.jasper', 0, 0, 'simple_receipt_with_stamp.jasper', 'AcademiaLogo.png'),
(63,3,'MANAGE_BILLS_STUDENT_CODE','Bill- Student End','Bill.png','CommonReport.jasper',NULL,'All',1,'Header.jasper','Footer.jasper',0,0,'manageBill_student.jasper','AcademiaLogo.jpg'),
(64,4,'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE','Receipt Settlement -Student End','Detailed_Receipt_One Page.png','CommonReport.jasper',NULL,'All',1,'Header.jasper','Footer.jasper',0,0,'ManageReceiptSettlement_Student.jasper','AcademiaLogo.jpg'),
(65,1, 'MANAGE_RECEIPT_STUDENT_CODE', 'Simple Receipt-Student End', 'Simple_Receipt_Duplicate.png', 'CommonReport.jasper',NULL, 'All', 1, 'FooterBlank.jasper', 'FooterBlank.jasper', 0, 0, 'simple_receipt_student_end.jasper', 'AcademiaLogo.png'),
(66,2,'DRS_IBDP_TYPE_LEVEL_SEMESTER_REPORT', 'DRS IBDP Type level semester report','DRS_IBDP_TYPE_LEVEL_SEMESTER_REPORT.png', 'CommonReport_PageBoder_DRS.jasper','EVALUATION_TYPE', 'All', 1, 'Header_DRS_CBSE_PYP_Marksheet.jasper', 'FooterBlank.jasper', 1, 1, 'DRS_IBDP_TYPE_LEVEL_SEMESTER_REPORT.jasper', 'AcademiaLogo.png'),
(67,10,'StudentSummaryReport','Student Summary Report','StudentSummaryReport.png','CommonReport_PageBoder_DRS.jasper',NULL,'All',1,'Header_Application_summary.jasper','Footer_UoA.jasper',1,1,'StudentSummaryReport.jasper','AcademiaLogo.png'),
(68,2, 'DRS_PYP_TYPE_LEVEL_SEMESTER_REPORT', 'DRS PYP Type Level Marksheet', 'DRS_PYP_TYPE_LEVEL_SEMESTER_REPORT.png', 'CommonReport_PageBoder_DRS_PYP.jasper','EVALUATION_TYPE', 'All', '1', 'Header_DRS_CBSE_PYP_Marksheet.jasper', 'FooterBlank.jasper', '1', '1', 'DRS_PYP_TYPE_LEVEL_SEMESTER_REPORT.jasper', 'AcademiaLogo.png'),
(69,2, 'DRS_CBSE_PLAN_LEVEL_TRANSCRIPT_REPORT', 'DRS CBSE Plan Level Marksheet', 'DRS_CBSE_PLAN_LEVEL_TRANSCRIPT_REPORT.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'DRS_CBSE_PLAN_LEVEL_TRANSCRIPT_REPORT_FRONTPAGE.jasper', 'AcademiaLogo.png'),
(70,2, 'DRS_CIE_IGCSE_TYPE_LEVEL_MARKSHEET', 'DRS CIE/IGCSE Type Level Marksheet', 'DRS_CIE_IGCSE_TYPE_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', '1', 'Header_DRS_CBSE_PYP_Marksheet.jasper', 'Footer_DRS.jasper', '1', '1', 'DRS_CIE_IGCSE_TYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(71,2, 'DRS_CIE_IGCSE_PLAN_LEVEL_MARKSHEET', 'DRS CIE/IGCSE Plan Level Consolidated Marksheet', 'DRS_CIE_IGCSE_PLAN_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'Header_DRS_CBSE_PYP_Marksheet.jasper', 'Footer_DRS.jasper', '1', '1', 'DRS_CIE_IGCSE_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(72,'7', 'DRS_STUDENT_ID_CARD_FRONT', 'DRS Student ID Card Front', 'DRS_STUDENT_ID_CARD_FRONT.png', 'CommonReport_IdCard_Vertical.jasper',NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'DRS_STUDENT_ID_CARD_FRONT.jasper', 'AcademiaLogo.png'),
(73,'13', 'DRS_EMPLOYEE_ID_CARD_FRONT', 'DRS Employee ID Card Front', 'DRS_EMPLOYEE_ID_CARD_FRONT.png', 'CommonReport_IdCard_Vertical.jasper',NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'DRS_EMPLOYEE_ID_CARD_FRONT.jasper', 'AcademiaLogo.png'),
(74,'10', 'EvaluationEventWiseReport', 'Event Wise Marksheet Report', 'EvaluationEventWiseReport.png', 'CommonReport_Marksheet_Excel.jasper',NULL, 'All', '1', 'Header_Excel.jasper', 'Header_Excel.jasper', '0', '0', 'EvaluationEventWiseReport.jasper', 'AcademiaLogo.png'),
(75,'10', 'EvaluationMethodWiseReport', 'Method Wise Marksheet Report', 'EvaluationMethodWiseReport.png', 'CommonReport_Marksheet_Excel.jasper',NULL, 'All', '1', 'Header_Excel.jasper', 'Header_Excel.jasper', '0', '0', 'EvaluationMethodWiseReport.jasper', 'AcademiaLogo.png'),
(76,'10', 'EvaluationSubTypeWiseReport', 'Sub Type Wise Marksheet Report', 'EvaluationSubTypeWiseReport.png', 'CommonReport_Marksheet_Excel.jasper',NULL, 'All', '1', 'Header_Excel.jasper', 'Header_Excel.jasper', '0', '0', 'EvaluationSubTypeWiseReport.jasper', 'AcademiaLogo.png'),
(77,'10', 'EvaluationTypeWiseReport', 'Type Wise Marksheet Report', 'EvaluationTypeWiseReport.png', 'CommonReport_Marksheet_Excel.jasper',NULL, 'All', '1', 'Header_Excel.jasper', 'Header_Excel.jasper', '0', '0', 'EvaluationTypeWiseReport.jasper', 'AcademiaLogo.png'),
(78,2, 'DRS_CBSE_XI_TYPE_LEVEL_MARKSHEET', 'DRS CBSE Non Board Type Level Marksheet', 'DRS_CBSE_XI_TYPE_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_TYPE', 'All', '1', 'Header_DRS_CBSE_PYP_Marksheet.jasper', 'Footer_DRS.jasper', '1', '1', 'DRS_CBSE_XI_TYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(79,2, 'DRS_CBSE_XI_PLAN_LEVEL_MARKSHEET', 'DRS CBSE Non Board Plan Level Marksheet', 'DRS_CBSE_XI_PLAN_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'DRS_CBSE_XI_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(80,10,'STUDENT_ATTENDANCE_REPORT_REGISTER','Student Register Report','STUDENT_ATTENDANCE_REPORT_REGISTER.png','CommonReport_Excel.jasper',NULL,'All','1','Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'AttendanceRegister.jasper', 'AcademiaLogo.png'),
(81,2,'MIIT_COURSE_LEVEL_MARKSHEET','MIIT Course Wise Semester Marksheet','MIIT_COURSE_LEVEL_MARKSHEET.png','CommonReport.jasper','EVALUATION_PLAN','All',1,'FooterBlank.jasper','Footer_MIIT.jasper',1,1,'MIIT_COURSE_LEVEL_MARKSHEET.jasper','AcademiaLogo.png'),
(82,2,'MIIT_COURSE_LEVEL_TRANSCRIPT','MIIT Course Wise Semester Transcript','MIIT_COURSE_LEVEL_TRANSCRIPT.png','CommonReport_PageNumber_MIIT.jasper','EVALUATION_PLAN','All',1,'FooterBlank.jasper','Footer_MIIT.jasper',1,1,'MIIT_COURSE_LEVEL_TRANSCRIPT.jasper','AcademiaLogo.png'),
(83,'16', 'SGSITS_RollList', 'SGSITS Roll List', 'SGSITS_RollList.png', 'CommonReport_LandScape_PageNo.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_RollList.jasper', 'AcademiaLogo.png'),
(84,'8', 'SGSITS_COURSE_LEVEL_HALL_TICKET', 'SGSITS Hall Ticket', 'SGSITS_COURSE_LEVEL_HALL_TICKET.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_COURSE_LEVEL_HALL_TICKET.jasper', 'AcademiaLogo.png'), 
(85,'2', 'SGSITS_PLAN_LEVEL_MARKSHEET', 'SGSITS Plan Level Semester Marksheet', 'SGSITS_PLAN_LEVEL_MARKSHEET.png', 'CommonReport_LandScape.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'), 
(86,'2', 'SGSITS_PLAN_LEVEL_TRANSCRIPT', 'SGSITS Plan Level Semester Transcript', 'SGSITS_PLAN_LEVEL_TRANSCRIPT.png', 'CommonReport_LandScape.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_PLAN_LEVEL_TRANSCRIPT.jasper', 'AcademiaLogo.png'),
(87,'17', 'SGSITS_FOILS_REPORT', 'SGSITS Foils Report', 'SGSITS_FOILS_REPORT.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_FOILS_REPORT.jasper', 'AcademiaLogo.png'), 
(88,'18', 'SGSITS_ABSENTEE_REPORT', 'SGSITS Absentee Report', 'SGSITS_ABSENTEE_REPORT.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_ABSENTEE_REPORT.jasper', 'AcademiaLogo.png'), 
(89,'19', 'SGSITS_ATTENDANCE_SHEET', 'SGSITS Attendance Sheet', 'SGSITS_ATTENDANCE_SHEET.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_ATTENDANCE_SHEET.jasper', 'AcademiaLogo.png'),
(90,'14', 'SGSITS_TABULATION_REGISTER', 'SGSITS RGPV Tabulation Register', 'SGSITS_TABULATION_REGISTER.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'Footer_Tabulation_RGPV.jasper', '1', '1', 'SGSITS_TABULATION_REGISTER.jasper', 'AcademiaLogo.png'), 
(91,'15', 'SGSITS_AttestationForm', 'SGSITS Attestation Form', 'SGSITS_AttestationForm.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_AttestationForm.jasper', 'AcademiaLogo.png'),
(92,'2', 'IIITB_COURSE_LEVEL_MARKSHEET', 'IIITB Course Wise Semester Marksheet', 'IIITB_COURSE_LEVEL_MARKSHEET.png', 'CommonReport.jasper', 'EVALUATION_PLAN','All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'IIITB_COURSE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(93,'13', 'CVV_EMPLOYEE_ID_CARD', 'CVV Employee Id Card', 'CVV_EMPLOYEE_ID_CARD.png', 'CommonReport_IdCard_Vertical.jasper',NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'employeeIDCard_CVV.jasper', 'AcademiaLogo.png'),
(94,'7', 'CVV_STUDENT_ID_CARD', 'CVV STUDENT Id Card', 'CVV_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical.jasper',NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_CVV.jasper', 'AcademiaLogo.png'),
(95,'2', 'MIIT_COURSE_LEVEL_MARKSHEET_S', 'MIIT Course Level SGPA Marksheet', 'MIIT_COURSE_LEVEL_MARKSHEET_S.png', 'CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'Footer_MIIT.jasper', '1', '1', 'MIIT_COURSE_LEVEL_MARKSHEET_S.jasper', 'AcademiaLogo.png'),
(96,'2', 'MIIT_COURSE_LEVEL_TRANSCRIPT_S', 'MIIT Course Level SGPA Transcript', 'MIIT_COURSE_LEVEL_TRANSCRIPT_S.png', 'CommonReport_PageNumber_MIIT.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'Footer_MIIT.jasper', '1', '1', 'MIIT_COURSE_LEVEL_TRANSCRIPT_S.jasper', 'AcademiaLogo.png'),
(97,'10', 'STUDENT_ENROLLMENT_SUMMARY_REPORT', 'Enrollment Summary Report', 'EnrollmentSummaryReport.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'StudentEnrollmentSummaryReport.jasper', 'AcademiaLogo.png'),
(98,'17', 'SGSITS_THEORY_FOILS_REPORT', 'SGSITS Theory Foils Report', 'SGSITS_THEORY_FOILS_REPORT.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_THEORY_FOILS_REPORT.jasper', 'AcademiaLogo.png'),
(99,'14', 'SGSITS_TRANSCRIPT_TABULATION_REGISTER', 'SGSITS RGPV Transcript Tabulation Register', 'SGSITS_TRANSCRIPT_TABULATION_REGISTER.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'Footer_Tabulation_RGPV.jasper', '1', '1', 'SGSITS_TRANSCRIPT_TABULATION_REGISTER.jasper', 'AcademiaLogo.png'),
(100,'13', 'AU_EMPLOYEE_ID_CARD', 'AU Employee Id Card', 'AU_EMPLOYEE_ID_CARD.png', 'CommonReport_IdCard_Horizontally.jasper',NULL, 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'employeeIDCard_AU.jasper', 'AcademiaLogo.png'),
(101,'7', 'AU_STUDENT_ID_CARD', 'AU Student Id Card', 'AU_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Horizontally.jasper',NULL, 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'studentIDCard_AU.jasper', 'AcademiaLogo.png'),
(102,'2', 'IIITB_COURSE_LEVEL_MASTER_TRANSCRIPT', 'IIITB two year Programs Transcript', 'IIITB_COURSE_LEVEL_MASTER_TRANSCRIPT.png', 'CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'IIITB_COURSE_LEVEL_MASTER_TRANSCRIPT.jasper', 'AcademiaLogo.png'),
(103,'17', 'SGSITS_MARKS_FOILS_REPORT', 'SGSITS Marks Foils Report', 'SGSITS_MARKS_FOILS_REPORT.png', 'CommonReport_PageNumber.jasper', NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SGSITS_MARKS_FOILS_REPORT.jasper', 'AcademiaLogo.png'),
(104, '10', 'EVENT_MEETING_MINUTE_REPORT', 'Event Meeting Minute Report', 'EVENT_MEETING_MINUTE_REPORT.png', 'CommonReport.jasper', NULL, 'All', '1', 'FooterBlank.jasper', 'committee_footer.jasper', '1', '1', 'Committee_MinutesMeeting.jasper', 'AcademiaLogo.png'),
(105, '10', 'EVENT_MEETING_MINUTE_ATTENDANCE_SHEET', 'Event Meeting Attendance Sheet', 'EVENT_MEETING_MINUTE_ATTENDANCE_SHEET.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'Committee_EventAttendanceSheet.jasper', 'AcademiaLogo.png'),
(106, '10', 'STUDENT_RELGION_WISE_REPORT', 'Student Religion Wise Report', 'STUDENT_RELGION_WISE_REPORT.png', 'CommonReport_Excel.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'StudentReligionWiseReport.jasper', 'AcademiaLogo.png'),
(107, '10', 'STUDENT_STATISTICS_REPORT', 'Student Statistics Report', 'STUDENT_STATISTICS_REPORT.png', 'CommonReport_Excel.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'StudentStatisticsReport.jasper', 'AcademiaLogo.png'),
(108, '10', 'STUDENT_DATA_REPORT', 'Student Data Report', 'STUDENT_DATA_REPORT.png', 'CommonReport_Excel.jasper',NULL, 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'studentDataReport.jasper', 'AcademiaLogo.png'),
(109, '10', 'STUDENT_GRADUATION_REPORT', 'Student Graduation Report', 'STUDENT_GRADUATION_REPORT.png', 'CommonReport_Excel.jasper',NULL, 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'StudentGraduationReport.jasper', 'AcademiaLogo.png'),
(110, '2', 'TSM_COURSE_LEVEL_MARKSHEET', 'TSM Course Level Marksheet', 'TSM_COURSE_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'TSM_COURSE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(111,'7', 'SYSCOMS_STUDENT_ID_CARD', 'SYSCOMS Student Id Card', 'SYSCOMS_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Horizontally.jasper',NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_SYSCOMS.jasper', 'AcademiaLogo.png'),
(112,'2', 'UOJ_COURSE_LEVEL_TRANSCRIPT', 'UOJ Course Level Transcript', 'UOJ_COURSE_LEVEL_TRANSCRIPT.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'UOJ_COURSE_LEVEL_TRANSCRIPT.jasper', 'AcademiaLogo.png'),
(113,'2', 'TSM_COURSE_LEVEL_TRANSCRIPT', 'TSM Course Level Transcript', 'TSM_COURSE_LEVEL_TRANSCRIPT.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'TSM_COURSE_LEVEL_TRANSCRIPT.jasper', 'AcademiaLogo.png'),
(114, '2', 'DRS_CBSE_X_PLAN_LEVEL_MARKSHEET', 'DRS CBSE X Plan Level Marksheet', 'DRS_CBSE_X_PLAN_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'DRS_CBSE_X_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(115, '2', 'DRS_CBSE_XII_PLAN_LEVEL_MARKSHEET', 'DRS CBSE XII Plan Level Marksheet', 'DRS_CBSE_XII_PLAN_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'DRS_CBSE_XII_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(116, '10', 'STUDENT_WISE_DISPATCH_FORM', 'Student Wise Dispatch Form', 'STUDENT_WISE_DISPATCH_FORM.png', 'CommonReport_StudentWiseDispatchForm.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'StudentWiseDispatchForm.jasper', 'AcademiaLogo.png'),
(117, '20', 'GRADE_ROSTER_REPORT_TERM_WISE', 'Grade Roster Report Term Wise', 'GRADE_ROSTER_REPORT_TERM_WISE.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'GRADE_ROSTER_REPORT_TERM_WISE.jasper', 'AcademiaLogo.png'),
(118,'14', 'SGSITS_DAVV_TABULATION_REGISTER', 'SGSITS DAVV Tabulation Register', 'SGSITS_DAVV_TABULATION_REGISTER.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'Footer_Tabulation_DAVV.jasper', '1', '1', 'SGSITS_DAVV_TABULATION_REGISTER.jasper', 'AcademiaLogo.png'),
(119,'14', 'SGSITS_DAVV_TRANSCRIPT_TABULATION_REGISTER', 'SGSITS DAVV Transcript Tabulation Register', 'SGSITS_DAVV_TRANSCRIPT_TABULATION_REGISTER.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'Footer_Tabulation_DAVV.jasper', '1', '1', 'SGSITS_DAVV_TRANSCRIPT_TABULATION_REGISTER.jasper', 'AcademiaLogo.png'),
(120,'10','EmployeeSummaryReport','Employee Summary Report','EmployeeSummaryReport.png','CommonReport_PageBoder_DRS.jasper',NULL,'All',1,'Header_EmployeeSummaryReport.jasper','Footer_UoA.jasper',1,1,'Header_EmployeeSummaryReport.jasper','AcademiaLogo.png'),
(121, '21', 'COURSE_ROSTER_REPORT_TERM_WISE', 'Course Roster Report Term Wise', 'COURSE_ROSTER_REPORT_TERM_WISE.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'COURSE_ROSTER_REPORT_TERM_WISE.jasper', 'AcademiaLogo.png'),
(122,'7', 'SGSITS_STUDENT_ID_CARD', 'SGSITS Student Id Card', 'SGSITS_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_SGSITS.jasper', 'AcademiaLogo.png'),
(123,'22','CROSS_LIST_FOR_STUDENT','Cross List Report for Student','CROSS_LIST_FOR_STUDENT.png','CommonReport_PageNumber.jasper',NULL,'All',1,'FooterBlank.jasper','Footer_CROSSLIST_SGSITS.jasper',1,1,'CROSS_LIST_FOR_STUDENT.jasper','AcademiaLogo.png'),
(124,'22','CROSS_LIST_FOR_EXAM_DEPARTMENT','Cross List Report for Department','CROSS_LIST_FOR_EXAM_DEPARTMENT.png','CommonReport_Excel.jasper',NULL,'All',1,'Header_Excel_Blank.jasper','Footer_Excel_Blank.jasper',1,1,'CROSS_LIST_FOR_EXAM_DEPARTMENT.jasper','AcademiaLogo.png'),
(125,'10','STUDENT_DETAIL_REPORT','Student Detail Report','STUDENT_DETAIL_REPORT.png','CommonReport.jasper',null,'All','1','FooterBlank.jasper','FooterBlank.jasper','1','1','STUDENT_DETAIL_REPORT.jasper','AcademiaLogo.png'),
(126,'10','STUDENT_COURSE_ENROLLMENT','Enrolled Courses Form','STUDENT_COURSE_ENROLLMENT.png','CommonReport.jasper',null,'All','1','FooterBlank.jasper','FooterBlank.jasper','1','1','STUDENT_COURSE_ENROLLMENT.jasper','AcademiaLogo.png'),
(127,'23','USER_WISE_COLLECTION_REPORT','User Wise Collection Report','USER_WISE_COLLECTION_REPORT.png','CommonReport_Excel.jasper',null,'All','1','FooterBlank.jasper','FooterBlank.jasper','1','1','USER_WISE_COLLECTION_REPORT.jasper','AcademiaLogo.png'),
(128, '8', 'TSM_COURSE_LEVEL_HALL_TICKET', 'TSM Hall Ticket', 'TSM_COURSE_LEVEL_HALL_TICKET.png', 'CommonReport.jasper',null, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'TSM_COURSE_LEVEL_HALL_TICKET.jasper', 'AcademiaLogo.png'),
(129, '7', 'IIMT_STUDENT_ID_CARD', 'IIMT Student Id Card', 'IIMT_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_IIMT.jasper', 'AcademiaLogo.png'),
(130, '4','MANAGE_RECEIPT_SETTLEMENT_CODE','Receipt Settlement GST','ReceiptSettlementGST.png','CommonReport_WithAcknowledgement.jasper','All','0','FooterBlank.jasper','FooterBlank.jasper','0','0','ReceiptSettlementGST.jasper','AcademiaLogo.png'),
(131, '24','VelocityAdmissionSummaryReport','Admission Detail Report','VelocityAdmissionSummaryReport.png','CommonReport_LandScape.jasper','All','0','FooterBlank.jasper','FooterBlank.jasper','0','0','VelocityAdmissionSummaryReport.jasper','AcademiaLogo.png'),
(132, '24','VelocityAdmissionSummaryReport_Excel','Admission Detail Report','VelocityAdmissionSummaryReport_Excel.png','CommonReport_Excel.jasper','All','0','Header_Excel.jasper','Footer_Excel.jasper','0','0','VelocityAdmissionSummaryReport_Excel.jasper','AcademiaLogo.png'),
(133, '24','LeadSummaryReport','Lead Detail Report','LeadSummaryReport.png','CommonReport_LandScape.jasper','All','0','FooterBlank.jasper','FooterBlank.jasper','0','0','LeadSummaryReport.jasper','AcademiaLogo.png'),
(134, '24','LeadSummaryReport_Excel','Lead Detail Report','LeadSummaryReport_Excel.png','CommonReport_Excel.jasper','All','0','Header_Excel.jasper','Footer_Excel.jasper','0','0','LeadSummaryReport_Excel.jasper','AcademiaLogo.png'),
(135, '24','VelocityApplicationSummaryReport','Application Summary Report','VelocityApplicationSummaryReport.png','CommonReport_LandScape.jasper','All','0','FooterBlank.jasper','FooterBlank.jasper','0','0','VelocityApplicationSummaryReport.jasper','AcademiaLogo.png'),
(136, '24','VelocityApplicationSummaryReport_Excel','Application Summary Report','VelocityApplicationSummaryReport_Excel.png','CommonReport_Excel.jasper','All','0','Header_Excel.jasper','Footer_Excel.jasper','0','0','VelocityApplicationSummaryReport_Excel.jasper','AcademiaLogo.png'),
(137, '24','CampaignExportReport','Campaign Export Report','CampaignExportReport.png','CommonReport_Excel.jasper','All','0','Header_Excel.jasper','Footer_Excel.jasper','0','0','CampaignExportReport.jasper','AcademiaLogo.png'),
(138, '4' ,'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE','Receipt Settlement GST Student','ReceiptSettlementGST.png','CommonReport_WithAcknowledgement.jasper','All',0,'FooterBlank.jasper','FooterBlank.jasper',0,0,'ReceiptSettlementGST.jasper','AcademiaLogo.png'),
(139, '1' ,'MANAGE_RECEIPT_CODE','Simple Receipt - Triplicate Velocity','Receipt_Triplicate_Velocity.png','CommonReport.jasper','All',0,'FooterBlank.jasper','FooterBlank.jasper',0,0,'ManageReceipt_Triplet_Velocity.jasper','AcademiaLogo.png'),
(140,'10','GRADE_WISE_REPORT','Grade Wise Report','GRADE_WISE_REPORT.png','CommonReport_Excel.jasper',NULL,'All','0','Header_Excel.jasper','Footer_Excel.jasper','0','0','GradeWiseReport.jasper','AcademiaLogo.png'),
(141, '1' ,'MANAGE_RECEIPT_CODE','Simple Receipt - Duplicate Velocity','Receipt_Duplicate_Velocity.png','CommonReport.jasper','All',0,'FooterBlank.jasper','FooterBlank.jasper',0,0,'ManageReceipt_Double_Velocity.jasper','AcademiaLogo.png'),
(142,'19', 'TSM_ATTENDANCE_SHEET', 'TSM Attendance Sheet', 'TSM_ATTENDANCE_SHEET.png', 'CommonReport_PageNumber.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'TSM_ATTENDANCE_SHEET.jasper', 'AcademiaLogo.png'),
(143,'25','ExportFeeHeadWiseReport','Fee Head Report','FeeHeadWiseReport.png','CommonReport_Excel.jasper',null,'All','1','Header_Excel.jasper','Footer_Excel.jasper','0','0','FeeHeadWiseReport.jasper','AcademiaLogo.png'),
(144, '2', 'TERNA_PLAN_LEVEL_MARKSHEET', 'Terna Plan Level Marksheet', 'TERNA_PLAN_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'Footer_TERNA.jasper', '1', '1', 'TERNA_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(145, '2', 'IMI_PLAN_LEVEL_MARKSHEET', 'IMI Plan Level Marksheet', 'IMI_PLAN_LEVEL_MARKSHEET.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'Footer_IMI.jasper', '1', '1', 'IMI_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(146, '2', 'ASHOKA_VI_TO_X_TYPE_LEVEL_MARKSHEET', 'ASHOKA VI to X Type Level Marksheet', 'ASHOKA_VI_TO_X_TYPE_LEVEL_MARKSHEET.png', 'CommonReport_PageNumber.jasper','EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'Footer_Ashoka.jasper', '1', '1', 'ASHOKA_VI_TO_X_TYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(147, '2', 'ASHOKA_I_TO_V_TYPE_LEVEL_MARKSHEET', 'ASHOKA I to V Type Level Marksheet', 'ASHOKA_I_TO_V_TYPE_LEVEL_MARKSHEET.png', 'CommonReport_PageNumber.jasper','EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'Footer_Ashoka.jasper', '1', '1', 'ASHOKA_I_TO_V_TYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(148, '2', 'ASHOKA_AGA_I_TO_II_TYPE_LEVEL_MARKSHEET', 'ASHOKA AGA I to II Type Level Marksheet', 'ASHOKA_AGA_I_TO_II_TYPE_LEVEL_MARKSHEET.png', 'CommonReport_PageNumber.jasper','EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'Footer_Ashoka_AGA.jasper', '1', '1', 'ASHOKA_AGA_I_TO_II_TYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(149, '2', 'ASHOKA_AGA_III_TO_IV_TYPE_LEVEL_MARKSHEET', 'ASHOKA AGA III to IV Type Level Marksheet', 'ASHOKA_AGA_III_TO_IV_TYPE_LEVEL_MARKSHEET.png', 'CommonReport_PageNumber.jasper','EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'Footer_Ashoka.jasper', '1', '1', 'ASHOKA_AGA_III_TO_IV_TYPE_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(150, '2', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_WITHOUT_ZONE', 'TSG - Single term Health marksheet(Without Zone)', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_WITHOUT_ZONE.png', 'CommonReport.jasper', 'EVALUATION_TYPE', 'All', '1', 'Header_TSG.jasper', 'Footer_TSG.jasper', '1', '1', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_WITHOUT_ZONE.jasper', 'AcademiaLogo.png'),
(151, '2', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_WITHOUT_ZONE', 'TSG - Consolidated Health marksheet(Without Zone)', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_WITHOUT_ZONE.png', 'CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'Header_TSG.jasper', 'Footer_TSG.jasper', '1', '1', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_WITHOUT_ZONE.jasper', 'AcademiaLogo.png'),
(152, '2', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_GRAY_WITHOUT_ZONE', 'TSG - Single term Health marksheet-Gray shade(Without Zone)', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_GRAY_WITHOUT_ZONE.png', 'CommonReport.jasper', 'EVALUATION_TYPE', 'All', '1', 'Header_TSG.jasper', 'Footer_TSG.jasper', '1', '1', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_GRAY_WITHOUT_ZONE.jasper', 'AcademiaLogo.png'),
(153, '2', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_GRAY_WITHOUT_ZONE', 'TSG - Consolidated Health marksheet-Gray Shade(Without Zone)', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_GRAY_WITHOUT_ZONE.png', 'CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'Header_TSG.jasper', 'Footer_TSG.jasper', '1', '1', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_GRAY_WITHOUT_ZONE.jasper', 'AcademiaLogo.png'),
(154, '8', 'IIMT_COURSE_LEVEL_HALL_TICKET', 'IIMT Hall Ticket', 'IIMT_COURSE_LEVEL_HALL_TICKET.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'IIMT_COURSE_LEVEL_HALL_TICKET.jasper', 'AcademiaLogo.png'),
(155, '16','IIMT_RollList', 'IIMT Roll List', 'IIMT_RollList.png', 'CommonReport_LandScape_PageNo.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'IIMT_RollList.jasper', 'AcademiaLogo.png'),
(156, '15','IIMT_AttestationForm', 'IIMT Attestation Form', 'IIMT_AttestationForm.png', 'CommonReport.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'IIMT_AttestationForm.jasper', 'AcademiaLogo.png'),
(157, '25', 'FeePlanSummaryReport', 'Fee Plan Summary Report', 'FeePlanSummaryReport.png', 'CommonReport_Excel.jasper', NULL, 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '0', '0', 'FeePlanSummaryReport.jasper', 'AcademiaLogo.png'),
(158, '2', 'VELOCITY_IEB_DBE_IV_VI_MARKSHEET', 'Velocity IEB DBE IV VI Marksheet', 'VELOCITY_IEB_DBE_IV_VI_MARKSHEET.png', 'CommonReport_Velocity.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_IV_VI_MARKSHEET.jasper', 'AcademiaLogo.png'),
(159, '2', 'VELOCITY_IEB_DBE_I_III_MARKSHEET', 'Velocity IEB DBE I III MARKSHEET', 'VELOCITY_IEB_DBE_I_III_MARKSHEET.png', 'CommonReport_Velocity.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_I_III_MARKSHEET.jasper', 'AcademiaLogo.png'),
(160, '2', 'VELOCITY_IEB_DBE_X_XII_MARKSHEET', 'Velocity IEB DBE X XII MARKSHEET', 'VELOCITY_IEB_DBE_X_XII_MARKSHEET.png', 'CommonReport_Velocity.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_X_XII_MARKSHEET.jasper', 'AcademiaLogo.png'),
(161, '2', 'VELOCITY_IEB_DBE_VII_IX_MARKSHEET', 'Velocity IEB DBE VII IX Marksheet', 'VELOCITY_IEB_DBE_VII_IX_MARKSHEET.png','CommonReport_Velocity.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_VII_IX_MARKSHEET.jasper', 'AcademiaLogo.png'),
(162, '2', 'ASHOKA_IX_TO_X_PLAN_LEVEL_MARKSHEET', 'ASHOKA IX TO X Plan Level Marksheet', 'ASHOKA_IX_TO_X_PLAN_LEVEL_MARKSHEET.png', 'CommonReport_LandScape.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'Footer_Ashoka.jasper', '1', '1', 'ASHOKA_IX_TO_X_PLAN_LEVEL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(163, '2', 'VELOCITY_IEB_DBE_STATEMENT_OF_RESULT', 'Velocity IEB DBE Statement Of Result', 'VELOCITY_IEB_DBE_STATEMENT_OF_RESULT.png',	'CommonReport_Velocity.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_STATEMENT_OF_RESULT.jasper', 'AcademiaLogo.png'), 
(164, '2', 'VELOCITY_IEB_DBE_GRADE_0_0000', 'Velocity IEB DBE Grade 0 0000', 'VELOCITY_IEB_DBE_GRADE_0_0000.png',	'CommonReport_Velocity.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_GRADE_0_0000.jasper', 'AcademiaLogo.png'),
(165, '10','STUDENT_ATTENDANCE_COMPLETE_DAY_REPORT_REGISTER','Student Complete Day Register Report','STUDENT_ATTENDANCE_COMPLETE_DAY_REPORT_REGISTER.png','CommonReport_Excel.jasper', NULL,'All','1','Header_Excel.jasper','Footer_Excel.jasper', '1', '1', 'AttendanceRegister_ForCompleteDay.jasper', 'AcademiaLogo.png'),
(166, '25', 'PROGRAM_FEE_PLAN_MAPPING_REPORT', 'Program Fee Plan Mapping Report', 'PROGRAM_FEE_PLAN_MAPPING_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '0', '0', 'ProgramFeePlanMapping.jasper', 'AcademiaLogo.png'),
(167, '2', 'VELOCITY_ABBOTTS_VIII_IX_MARKSHEET', 'VELOCITY ABBOTTS VIII IX MARKSHEET', 'VELOCITY_ABBOTTS_VIII_IX_MARKSHEET.png', 'CommonReport_Velocity_Landscape.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_ABBOTTS_VIII_IX_MARKSHEET.jasper', 'AcademiaLogo.png'),
(168, '2', 'VELOCITY_ABBOTTS_X_XII_MARKSHEET', 'VELOCITY ABBOTTS X XII MARKSHEET', 'VELOCITY_ABBOTTS_X_XII_MARKSHEETT.png', 'CommonReport_Velocity_Landscape.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_ABBOTTS_X_XII_MARKSHEET.jasper', 'AcademiaLogo.png'),
(169, '2', 'TSM_CONSOLIDATED_GRADE_STATEMENT_TRANSCRIPT', 'TSM Consolidated Grade Statement Transcript', 'TSM_CONSOLIDATED_GRADE_STATEMENT_TRANSCRIPT.png', 'CommonReport_Legal_Portrait.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'TSM_CONSOLIDATED_GRADE_STATEMENT_TRANSCRIPT.jasper', 'AcademiaLogo.png'),
(170, '2', 'TSM_STATEMENT_OF_GRADES', 'TSM Statement Of Grades', 'TSM_STATEMENT_OF_GRADES.png', 'CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'TSM_STATEMENT_OF_GRADES.jasper', 'AcademiaLogo.png'),
(171, '2', 'VELOCITY_IEB_DBE_IV_VI_MARKSHEET_WITHOUTGRADEAVERAGE', 'IEB/DBE 4-6 Report Card Without Grade Average', 'VELOCITY_IEB_DBE_IV_VI_MARKSHEET_WITHOUTGRADEAVERAGE.png', 'CommonReport_Velocity.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_IV_VI_MARKSHEET_withoutGradeAverage.jasper', 'AcademiaLogo.png'),
(172, '2', 'VELOCITY_IEB_DBE_VII_IX_MARKSHEET_WITHOUTGRADEAVERAGE', 'IEB/DBE 7-9 Report Card Without Grade Average', 'VELOCITY_IEB_DBE_VII_IX_MARKSHEET_WITHOUTGRADEAVERAGE.png', 'CommonReport_Velocity.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_VII_IX_MARKSHEET_withoutGradeAverage.jasper', 'AcademiaLogo.png'),
(173, '2', 'VELOCITY_IEB_DBE_X_XII_MARKSHEET_WITHOUTGRADEAVERAGE', 'IEB/DBE 10-12 Report Card Without Grade Average', 'VELOCITY_IEB_DBE_X_XII_MARKSHEET_WITHOUTGRADEAVERAGE.png', 'CommonReport_Velocity.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IEB_DBE_X_XII_MARKSHEET_withoutGradeAverage.jasper', 'AcademiaLogo.png'),
(174, '2', 'VELOCITY_ABBOTTS_VIII_IX_MARKSHEET_WITHOUTGRADEAVERAGE', 'IEB/DBE Abbotts 8-9 Report Card Without Grade Average', 'VELOCITY_ABBOTTS_VIII_IX_MARKSHEET_WITHOUTGRADEAVERAGE.png', 'CommonReport_Velocity_Landscape.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', '1', '1', 'VELOCITY_ABBOTTS_VIII_IX_MARKSHEET_withoutGradeAverage.jasper', 'AcademiaLogo.png'),
(175, '2', 'VELOCITY_ABBOTTS_X_XII_MARKSHEET_WITHOUTGRADEAVERAGE', 'IEB/DBE Abbotts 10-12 Report Card Without Grade Average', 'VELOCITY_ABBOTTS_X_XII_MARKSHEETT_WITHOUTGRADEAVERAGE.png', 'CommonReport_Velocity_Landscape.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_ABBOTTS_X_XII_MARKSHEET_withoutGradeAverage.jasper', 'AcademiaLogo.png'),
(176, '2', 'ASHOKA_I_TO_V_TERM_II_MARKSHEET', 'ASHOKA I TO V TERM II MARKSHEET', 'ASHOKA_I_TO_V_TERM_II_MARKSHEET.png', 'CommonReport.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'Footer_Ashoka.jasper', '1', '1', 'ASHOKA_I_TO_V_TERM_II_MARKSHEET.jasper', 'AcademiaLogo.png'),
(177, '8', 'OPJGU_HALL_TICKET', 'OPJGU Hall Ticket', 'OPJGU_HALL_TICKET.png', 'CommonReport.jasper', NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'OPJGU_HALL_TICKET.jasper', 'AcademiaLogo.png'),
(178, '24', 'VelocitySalesAndAdmissionSummaryReport_Excel', 'Sales And Admission Summary Report', 'VelocitySalesAndAdmissionSummaryReport.png', 'CommonReport_Excel.jasper', NULL, 'All', '1', 'FooterBlank.jasper', 'Footer_Excel.jasper', '0', '0', 'SalesAndAdmissionsSummary.jasper', 'AcademiaLogo.png'),
(179, '24', 'VelocitySalesAndAdmissionSummaryReport', 'Sales And Admission Summary Report', 'VelocitySalesAndAdmissionSummaryReport.png', 'CommonReport_Excel.jasper', NULL, 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '0', '0', 'SalesAndAdmissionsSummary.jasper', 'AcademiaLogo.png'), 
(180, '7', 'TSM_STUDENT_ID_CARD', 'TSM Student Id Card', 'TSM_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Horizontally.jasper',NULL, 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'studentIDCard_TSM.jasper', 'AcademiaLogo.png'),
(181, '7', 'AUS_STUDENT_ID_CARD', 'AUS Student Id Card', 'AUS_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical.jasper',NULL ,'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_AUS.jasper', 'AcademiaLogo.png'),
(182, '3', 'MANAGE_BILLS_CODE', 'Manage Discount Bill', 'Manage_Discount_Bill.png', 'CommonReport.jasper',NULL , 'All', '0', 'ManageDiscountBillHeader.jasper', 'Footer.jasper', '0', '0', 'ManageDiscountBill.jasper', 'AcademiaLogo.jpg'),
(183, '10', 'IIMT_STUDENT_COURSE_ENROLLMENT', 'Student Course Enrollment Form', 'IIMT_STUDENT_COURSE_ENROLLMENT.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'Footer_UoA.jasper', '1', '1', 'IIMT_STUDENT_COURSE_ENROLLMENT.jasper', 'AcademiaLogo.png'),
(184, '2', 'OPJGU_COURSE_LEVEL_MASTER_TRANSCRIPT', 'OPJGU Course Level Master Transcript', 'OPJGU_COURSE_LEVEL_MASTER_TRANSCRIPT.png', 'CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'OPJGU_COURSE_LEVEL_MASTER_TRANSCRIPT.jasper', 'AcademiaLogo.png'),
(185, '4', 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'Detailed Receipt - A5 Format (Student)', 'Detailed Receipt_A5_Format_(Student).png', 'CommonReport_A5_Format.jasper', NULL, 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'feeReceipt_JLU_A5.jasper', 'AcademiaLogo.png'),
(186, '4', 'MANAGE_RECEIPT_SETTLEMENT_CODE', 'Detailed Receipt - A5 Format (College)', 'Detailed Receipt_A5_Format_(College).png', 'CommonReport_A5_Format.jasper', NULL, 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'feeReceipt_JLU_A5.jasper', 'AcademiaLogo.png'),
(187, '2', 'CAMBRIDGE_PRE_SCHOOL_MARKSHEET', 'Cambridge Pre School Report Card', 'CAMBRIDGE_PRE_SCHOOL_MARKSHEET.png',	'CommonReport_Velocity_Grade_0_0000.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'CAMBRIDGE_PRE_SCHOOL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(188, '10', 'STUDENT_GENDER_REPORT', 'Student Gender Report', 'STUDENT_GENDER_REPORT.png', 'CommonReport_Excel.jasper', NULL, 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'StudentGenderReport.jasper', 'AcademiaLogo.png'),
(189, '7', 'PARISHKAR_STUDENT_ID_CARD', 'PARISHKAR Student Id Card', 'PARISHKAR_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_PARISHKAR.jasper', 'AcademiaLogo.png'),
(190, '17', 'IIMT_THEORY_FOILS_REPORT', 'IIMT Foils Report', 'IIMT_THEORY_FOILS_REPORT.png', 'CommonReport_PageNumber.jasper', NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'IIMT_THEORY_FOILS_REPORT.jasper', 'AcademiaLogo.png'),
(191, '2', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_WITHOUT_ZONE_TOP50', 'TSG - Consolidated Health marksheet top 50(Without Zone)', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_WITHOUT_ZONE_TOP50.png', 'CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'Header_TSG.jasper', 'Footer_TSG.jasper', '1', '1', 'MARKSHEET_TSG_PLAN_TO_METHOD_TEMPLATE_HEALTH_BASED_WITHOUT_ZONE_TOP50.jasper', 'AcademiaLogo.png'),
(192, '2', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_WITHOUT_ZONE_TOP50', 'TSG - Single term Health marksheet top 50 (Without Zone)', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_WITHOUT_ZONE_TOP50.png', 'CommonReport.jasper', 'EVALUATION_TYPE', 'All', '1', 'Header_TSG.jasper', 'Footer_TSG.jasper', '1', '1', 'MARKSHEET_TSG_TYPE_TO_METHOD_HEALTH_BASED_WITHOUT_ZONE_TOP50.jasper', 'AcademiaLogo.png'),
(193, '10', 'SELECTION_STAGE_REPORT', 'Selection Stage Report', 'SELECTION_STAGE_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '0', '0', 'SelectionStageReport.jasper', 'AcademiaLogo.png'),
(194, '10', 'ASSESSMENT_SCHEME_EXPORT_REPORT', 'Assessment Scheme Report', 'ASSESSMENT_SCHEME_REPORT.png', 'CommonReport_Excel.jasper', NULL,'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'ASSESSMENT_SCHEME_EXPORT_REPORT.jasper', 'AcademiaLogo.png'),
(195, '7', 'APU_STUDENT_ID_CARD', 'APU Student Id Card', 'APU_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical.jasper', NULL,'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'studentIDCard_APU.jasper', 'AcademiaLogo.png'),
(196, '2', 'CAMBRIDGE_IV_VII_MARKSHEET', 'Cambridge 4-7 Report Card', 'CAMBRIDGE_IV_VII_MARKSHEET.png', 'CommonReport_Velocity.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'CAMBRIDGE_IV_VII_MARKSHEET.jasper', 'AcademiaLogo.png'),
(197, '2', 'SIS_GRADE_BOOK_P1_P2', 'SIS Grade Book P1-P2', 'SIS_GRADE_BOOK_P1_P2.png', 'CommonReport_SIS_MARKSHEET.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SIS_GRADE_BOOK_P1_P2.jasper', 'AcademiaLogo.png'),
(198, '2', 'SIS_GRADE_BOOK_PRE_SCHOOL', 'SIS Grade Book Pre School', 'SIS_GRADE_BOOK_PRE_SCHOOL.png', 'CommonReport_SIS_MARKSHEET.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SIS_GRADE_BOOK_PRE_SCHOOL_MARKSHEET.jasper', 'AcademiaLogo.png'),
(199,'26', 'SIS_ASSESSMENT_REPORT_P3_S4', 'SIS Assessment Report P3-S4', 'SIS_ASSESSMENT_REPORT_P3_S4.png', 'CommonReport_Excel.jasper', NULL, 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'SIS_ASSESSMENT_REPORT_P3_S4.jasper', 'AcademiaLogo.png'),
(200, '10', 'STUDENT_DETAIL_REPORT_FOR_SCHOOL', 'Student Detail Report For School', 'STUDENT_DETAIL_REPORT_FOR_SCHOOL.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'STUDENT_DETAIL_REPORT_FOR_SCHOOL.jasper', 'AcademiaLogo.png'),
(201, '10', 'STUDENT_SIBLINGS_DETAILED_REPORT', 'Student - Siblings Detailed Report', 'STUDENT_SIBLINGS_DETAILED_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '0', '0', 'STUDENT_SIBLINGS_DETAILED_REPORT.jasper', 'AcademiaLogo.png'),
(202, '2', 'CAMBRIDGE_RECEPTION_REPORT_CARD', 'Cambridge Reception Report Card', 'CAMBRIDGE_RECEPTION_REPORT_CARD.png', 'CommonReport_Velocity_Grade_0_0000.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'CAMBRIDGE_RECEPTION_REPORT_CARD.jasper', 'AcademiaLogo.png'),
(203, '27', 'STUDENT_PHOTO_REPORT', 'Student Photo Report', 'STUDENT_PHOTO_REPORT.png', 'CommonReport.jasper', NULL, 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'STUDENT_PHOTO_REPORT.jasper', 'AcademiaLogo.png'),
(204, '2', 'RDPS_XI_XII_HALF_YEARLY_MARKSHEET', 'RDPS XI XII Half Yearly Marksheet', 'RDPS_XI_XII_HALF_YEARLY_MARKSHEET.png', 'CommonReport_RDPS_MARKSHEET.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'RDPS_XI_XII_HALF_YEARLY_MARKSHEET.jasper', 'AcademiaLogo.png'),
(205,'4', 'MANAGE_RECEIPT_SETTLEMENT_CODE', 'Receipt Settlement RDPS', 'ReceiptSettlementRDPS.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ReceiptSettlementRDPS.jasper', 'AcademiaLogo.png'),
(206, '2', 'RDPS_XI_XII_FINAL_MARKSHEET', 'RDPS XI XII Final Marksheet', 'RDPS_XI_XII_FINAL_MARKSHEET.png', 'CommonReport_RDPS_MARKSHEET.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'RDPS_XI_XII_FINAL_MARKSHEET.jasper', 'AcademiaLogo.png');
(207, '1', 'MANAGE_RECEIPT_CODE', 'Simple Receipt - OPJGU', 'ReceiptOPJGU.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ReceiptOPJGU.jasper', 'AcademiaLogo.png');
(208, '1', 'MANAGE_RECEIPT_STUDENT_CODE', 'Simple Receipt OPJGU-Student End', 'ReceiptOPJGU.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ReceiptOPJGU.jasper', 'AcademiaLogo.png');
(209, '4', 'MANAGE_RECEIPT_SETTLEMENT_CODE', 'Receipt Settlement OPJGU', 'ReceiptSettlementOPJGU.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ReceiptSettlementOPJGU.jasper', 'AcademiaLogo.png');
(210, '4', 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'Receipt Settlement OPJGU Student End', 'ReceiptSettlementOPJGU.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ReceiptSettlementOPJGU.jasper', 'AcademiaLogo.png');
(211, '7', 'IIHMR(Ph.D.program)StudentIDCard', 'IIHMR(Ph.D. program) Student ID Card', 'IIHMR(Ph.D.program)StudentIDCard.png', 'CommonReport_IdCard_IIHMR.jasper', 'All', '0', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'IIHMR(Ph.D.Program)StudentIDCard.jasper', 'AcademiaLogo.png');
(212,'10', 'ApplicantDetailReportWithoutImageDisctintColumn', 'Applicant Detail Report Without Image', '', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '0', '0', 'ApplicantDetailReportWithoutImage.jasper', 'AcademiaLogo.png');
(213,'4', 'MANAGE_RECEIPT_SETTLEMENT_CODE', 'Receipt Settlement INIFD', 'ReceiptSettlementINIFD.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ReceiptSettlementINIFD.jasper', 'AcademiaLogo.png');
(214,'4', 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'Receipt Settlement INIFD Student End', 'ReceiptSettlementINIFDStudent.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ReceiptSettlementINIFDStudent.jasper', 'AcademiaLogo.png');
(215,'7', 'CHS_STUDENT_ID_CARD', 'CHS Student ID Card ', 'CHS_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '0', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'studentIDCard_CHS.jasper', 'AcademiaLogo.png');
(216,'10', 'STUDENT_STATISTICS_SEAT_TYPE_REPORT', 'Student Seat Type Report', 'STUDENT_SEAT_TYPE_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Footer_Excel.jasper', '1', '1', 'StudentSeatTypeReport.jasper', 'AcademiaLogo.png');